{********************************************
; File: Menus.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT MENUS;
INTERFACE
USES TYPES,QUICKDRAW,EVENTS,CONTROLS,WINDOWS;
CONST


{ MenuDefProc Codes }
mDrawMsg = $0000;
mChooseMsg = $0001;
mSizeMsg = $0002;
mDrawTitle = $0003;
mDrawMItem = $0004;
mGetMItemID = $0005;

{ Reference Flags }
menuRefPtr = $0000;
mRefHandle = $4000;
mRefResource = $8000;

{ Menu Flags }
menuAllowCache = $0008;
menuCustom = $0010;
menuXOR = $0020;
menuDisabled = $0080;
menuAlwaysCallMChoose = $0100;

{ Item Flags }
itemBold = $0001;
itemItalic = $0002;
itemUnderline = $0004;
itemXOR = $0020;
itemDivider = $0040;
itemDisabled = $0080;
itemOutline = $0800;
itemShadow = $1000;

{ Old Menu Flags }
mInvis = $0004;
mCustom = $0010;
mXor = $0020;
mSelected = $0040;
mDisabled = $0080;

{ MenuFlag Masks }
menuCacheMask = $0008;
customMenu = $0010;
xorMItemHilite = $0020;
xorTitleHilite = $0020;
underMItem = $0040;
disableItem = $0080;
disableMenu = $0080;
enableItem = $FF7F;
enableMenu = $FF7F;
noUnderMItem = $FFBF;
colorMItemHilite = $FFDF;
colorTitleHilite = $FFDF;
colorReplace = $FFDF;
standardMenu = $FFEF;

{ Other misc constants }
type2 = $0040;
{$IFC UNDEFINED mtItemRefArrayLength }  { MenuTemplate - default number of Ref's }
mtItemRefArrayLength = $0005;
{$SETC mtItemRefArrayLength := 0}
{$ENDC}
{$IFC UNDEFINED mbtMenuRefArrayLength }  { MenuBarTemplate - default number of Ref's }
mbtMenuRefArrayLength = $0005;
{$SETC mbtMenuRefArrayLength := 0}
{$ENDC}

TYPE
MenuBarRecHndl = ^MenuBarRecPtr;
MenuBarRecPtr = ^MenuBarRec;
MenuBarRec = CtlRec ;
MenuRecHndl = ^MenuRecPtr;
MenuRecPtr = ^MenuRec;
MenuRec = RECORD
    menuID : Integer; { Menu's ID number }
    menuWidth : Integer; { Width of menu }
    menuHeight : Integer; { Height of menu }
    menuProc : WordProcPtr; { Menu's definition procedure }
    menuFlag : Integer; { Bit flags }
    numOfItems : Integer;
    titleWidth : Integer; { Width of menu's title }
    titleName : Ptr;
    menuCache : Handle;
END;
MenuItemTemplate = PACKED RECORD
    version : Integer; { Version number (must be 0) }
    itemID : Integer; { Menu item ID }
    itemChar : Byte; { Primary keystroke character }
    itemAltChar : Byte; { Alternate keystroke character }
    itemCheck : Integer; { Character code for checked items }
    itemFlag : Integer; { Menu item flag word }
    itemTitleRef : Ref; { Reference to item title string }
END;
MenuTemplate = RECORD
    version : Integer; { Version number (must be 0) }
    menuID : Integer; { Menu ID }
    menuFlag : Integer; { Menu flag word }
    menuTitleRef : Ref; { Reference to menu title string }
    itemRefArray : ARRAY[1..mtItemRefArrayLength] OF Ref; { mtItemRefArrayLength references to menu items  }
END;
MenuBarTemplate = RECORD
    version : Integer; { Version number (must be 0) }
    menuFlag : Integer; { MenuBar flag word }
    menuRefArray : ARRAY[1..mbtMenuRefArrayLength] OF Ref; { mbtMenuRefArrayLength references to menus }
END;
PROCEDURE CalcMenuSize ( newWidth:Integer; newHeight:Integer; menuNum:Integer)  ;
PROCEDURE CheckMItem ( checkedFlag:Boolean; itemNum:Integer)  ;
FUNCTION CountMItems ( menuNum:Integer) : Integer ;
PROCEDURE DeleteMenu ( menuNum:Integer)  ;
PROCEDURE DeleteMItem ( itemNum:Integer)  ;
PROCEDURE DisableMItem ( itemNum:Integer)  ;
PROCEDURE DisposeMenu ( menuHandle:MenuRecHndl)  ;
PROCEDURE DrawMenuBar   ;
PROCEDURE EnableMItem ( itemNum:Integer)  ;
FUNCTION FixMenuBar  : Integer ;
PROCEDURE FlashMenuBar   ;
FUNCTION GetBarColors  : Longint ;
FUNCTION GetMenuBar  : MenuBarRecHndl ;
FUNCTION GetMenuFlag ( menuNum:Integer) : Integer ;
FUNCTION GetMenuMgrPort  : GrafPortPtr ;
FUNCTION GetMenuTitle ( menuNum:Integer) : Ptr ;
FUNCTION GetMHandle ( menuNum:Integer) : MenuRecHndl ;
FUNCTION GetMItem ( itemNum:Integer) : StringPtr ;
FUNCTION GetMItemFlag ( itemNum:Integer) : Integer ;
FUNCTION GetMItemMark ( itemNum:Integer) : Integer ;
FUNCTION GetMItemStyle ( itemNum:Integer) : TextStyle ;
FUNCTION GetMTitleStart  : Integer ;
FUNCTION GetMTitleWidth ( menuNum:Integer) : Integer ;
FUNCTION GetPopUpDefProc  : Ptr ;
FUNCTION GetSysBar  : MenuBarRecHndl ;
PROCEDURE HideMenuBar   ;
PROCEDURE HiliteMenu ( hiliteFlag:Boolean; menuNum:Integer)  ;
PROCEDURE InitPalette   ;
PROCEDURE InsertMenu ( addMenuHandle:MenuRecHndl; insertAfter:Integer)  ;
PROCEDURE InsertMItem ( addItemPtr:Ptr; insertAfter:Integer; menuNum:Integer)  ;
PROCEDURE InsertMItem2 ( refDesc:RefDescriptor; menuItemTRef:Ref; insertAfter:Integer; menuNumber:Integer)  ;
PROCEDURE MenuBootInit   ;
FUNCTION MenuGlobal ( menuGlobalMask:Integer) : Integer ;
PROCEDURE MenuKey ( taskRecPtr:WmTaskRec; barHandle:MenuBarRecHndl)  ;
PROCEDURE MenuNewRes   ;
PROCEDURE MenuRefresh ( redrawRoutinePtr:VoidProcPtr)  ;
PROCEDURE MenuReset   ;
PROCEDURE MenuSelect ( taskRecPtr:WmTaskRec; barHandle:MenuBarRecHndl)  ;
PROCEDURE MenuShutDown   ;
PROCEDURE MenuStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION MenuStatus  : Boolean ;
FUNCTION MenuVersion  : Integer ;
FUNCTION NewMenu ( menuStringPtr:Ptr) : MenuRecHndl ;
FUNCTION NewMenu2 ( refDesc:RefDescriptor; menuTRef:Ref) : MenuRecHndl ;
FUNCTION NewMenuBar ( theWindowPtr:WindowPtr) : MenuBarRecHndl ;
FUNCTION NewMenuBar2 ( refDesc:RefDescriptor; menuBarTRef:Ref; windowPortPtr:WindowPtr) : MenuBarRecHndl ;
FUNCTION PopUpMenuSelect ( selection:Integer; currentLeft:Integer; currentTop:Integer; flag:Integer; menuHandle:MenuRecHndl) : Integer ;
PROCEDURE SetBarColors ( newBarColor:Integer; newInvertColor:Integer; newOutColor:Integer)  ;
PROCEDURE SetMenuBar ( barHandle:MenuBarRecHndl)  ;
PROCEDURE SetMenuFlag ( newValue:Integer; menuNum:Integer)  ;
PROCEDURE SetMenuID ( newMenuNum:Integer; curMenuNum:Integer)  ;
PROCEDURE SetMenuTitle ( newStr:Str255; menuNum:Integer)  ;
PROCEDURE SetMenuTitle2 ( refDesc:RefDescriptor; titleRef:Ref; menuNum:Integer)  ;
PROCEDURE SetMItem ( newItemLine:Str255; itemNum:Integer)  ;
PROCEDURE SetMItem2 ( refDesc:RefDescriptor; menuItemTRef:Ref; menuItemID:Integer)  ;
PROCEDURE SetMItemBlink ( count:Integer)  ;
PROCEDURE SetMItemFlag ( newValue:Integer; itemNum:Integer)  ;
PROCEDURE SetMItemID ( newItemNum:Integer; curItemNum:Integer)  ;
PROCEDURE SetMItemMark ( mark:Integer; itemNum:Integer)  ;
PROCEDURE SetMItemName ( str:Str255; itemNum:Integer)  ;
PROCEDURE SetMItemName2 ( refDesc:RefDescriptor; titleRef:Ref; menuItemID:Integer)  ;
PROCEDURE SetMItemStyle ( theTextStyle:TextStyle; itemNum:Integer)  ;
PROCEDURE SetMTitleStart ( xStart:Integer)  ;
PROCEDURE SetMTitleWidth ( newWidth:Integer; menuNum:Integer)  ;
PROCEDURE SetSysBar ( barHandle:MenuBarRecHndl)  ;
PROCEDURE ShowMenuBar   ;
IMPLEMENTATION
END.
